/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 *                                                                          *
 * FILE NAME:   IAI_RF_MAC_Lite_Int.h                                      *
 *                                                                          *
 * DESIGNER:	Lukacs, Miklos; Kovacs, Krisztian                            *
 * PROGRAMMER: Lukacs, Miklos                                               *
 *                                                                          *
 * DESCRIPTION: EZmac Internal function definitions                         *
 *                                                                          *
 * REVISION:    01_5  Maj  10, 2005     From the original EZmac version     *
 *                                      removed:                            *
 *                                     - Multicast addressing.              *
 *                                     - Network address mode.              *
 *                                     - Reduced address mode.              *
 *                                     - Dynamic packet length.             *
 *                                     - Error detection.                   *
 *                                     - CID is mandatory.                  *
 *              01_6  Aug    11, 2005                                       *
 *				01_7  Dec	 08, 2005	Port to HiTech						*
 *                                                                          *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
#pragma nolist

#ifndef EZmac_Lite_internal
#define  EZmac_Lite_internal



                /* ======================================= *
                 *         I N T R O D U C T I O N         *
                 * ======================================= */

/* */

                /* ======================================= *
                 *           P A R A M E T E R S           *
                 * ======================================= */

//Timer1, prescaler = 8, clk = 4MHz -> one increment is 8us
#define WAKING_UP_PERIOD      (65535-625)    //5ms
#ifdef HITECH_COMPILER
 #define FIRST_DQD_TIMER_LIMIT (65535-10)     //400us after the change of the freq will be the first DQD sample
 #define DQD_TIMER_LIMIT       (65535-1)     //136us sample rate for DQD
#endif
#ifdef CCS_C_COMPILER
 #define FIRST_DQD_TIMER_LIMIT (65535-50)     //400us after the change of the freq will be the first DQD sample
 #define DQD_TIMER_LIMIT       (65535-17)     //136us sample rate for DQD
#endif
#define ONE_BYTE_TIMER_LIMIT  128            //not 840us, but 1.024ms (multiple by 2^x is much easier)
#define CRL_CHECK_TIMER_LIMIT  64            // 512us (multiple by 2^x is much easier)
#define TIMER_OVERFLOW        (65535)        //maximum value of the timer
#define MAX_RX_PACKET_TIMER   (65535-(ONE_BYTE_TIMER_LIMIT * 23))   //max.: CID,SID,DID,PLEN,16*DATA,EDC1,EDC2; 22 bytes
#define MAX_TX_PACKET_TIMER   (65535-(ONE_BYTE_TIMER_LIMIT * 37))   //max.: 11*Pre,2D,D4,CID,SID,DID,PLEN,16*DATA,EDC1,EDC2+1; 36 bytes

#define NMBR_OF_CHANNELS      8
//#define PREAMBLE_LENGTH       (3 + (NMBR_OF_CHANNEL * 1))
#define EDC_SIZE              2

#define CRC_16_PATTERN        0x8005      //bit pattern (1)1000 0000 0000 0101

#define DQD_SAMPLE            5

#define SpiPufLen             22

#define XTAL_COMP             0x000A      // 13.5pF

#define FIFO_USED             0x0040      //
#define FIFO_NOT_USED         0x0FFBF     //
#define TXREG_USED            0x0080      //
#define TXREG_NOT_USED        0x0FF7F     //

//changed by mlu for rev1.4
#define  RX_cmd_init_value    0x97A0          // BW:135kHz; VDI:always on; LNA:max; DRSSI:-103; Pin8: VDIout
#define  TX_cmd_init_value    0x9847          // f0+df; df:75kHz; Pout:min
#define  POW_cmd_init_value   0x8201          // switch everything off, also the clk output
#define  FIFO_cmd_init_value  0xCA81          // Fill:synchron pattern; IT level:8; disable sensitive reset
#define  DR_cmd_init_value    0xC623          // 9600bps
#define  DF_cmd_init_value    0xC2AF          // CR:AUTO; Digital LPF; DQD:7 //changed by mlu for rev1.5
#define  AFC_cmd_init_value   0xC4F7          // enabled; fine mode; auto,keep offset; +3/-4; output enabled

#define  WK_cmd_init_value    0xFFFF          // very long...
#define  LD_cmd_init_value    0xC80E          // 10%, off
#define  LB_cmd_init_value    0xC000          // uC clk:1MHz, threshold:2.2V

                /* ======================================= *
                 *          D E F I N I T I O N S          *
                 * ======================================= */
#define EZMAC_LITE

#undef bool
#undef FALSE
#undef TRUE

#define IT_SOURCE_T1          0
#define IT_SOURCE_COMM        0X80  //FIFO or TX register IT
#define IT_SOURCE_OVUR        0X20  //FIFO or TX register overrun/underrun
#define IT_SOURCE_COMM_OVUR   0XA0  //FIFO or TX register IT and overrun/underrun

#ifdef EZMAC_BOARD_WITH_ADC
 #define ARSSI_USED               //comment out this line if the ARSSI is not connected
 #define ARSSI_PIN           AN0  //which pin is connected to the ARSSI?
 #define ARSSI_CHANNEL       0
#endif

typedef enum
{
   EZ_Idle = 0,
   EZ_Sleep,
   EZ_WakeUp,
   EZ_RxDQDCheck,
   EZ_RxCheckCID,
   EZ_RxCheckSID,
   EZ_RxCheckDID,
   EZ_RxCheckPL,
   EZ_RxDataByte,
   EZ_RxCheckEDC,
   EZ_RxEnd,
   EZ_TxCheckChannel,
   EZ_TransmitError,
   EZ_TxSendPreamble,
   EZ_TxSendSyncPattern0,
   EZ_TxSendSyncPattern1,
   EZ_TxSendHeader1,
   EZ_TxSendHeader2,
   EZ_TxSendData,
   EZ_TxCalcCrc,
   EZ_TxCalcCrc1,
   EZ_TxSendEdc,
   EZ_TxEnd
} state;


#ifdef END_HARDWARE
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//                This is a sample I/O setting, it should be
//              changed according to the application Hardware!!!
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//changed by krk for pic18 test
/*
#define CLK_PIN             portb_reg.testreg.bit4  //
#define MOSI_PIN            portb_reg.testreg.bit3  //
#define MISO_PIN            portb_reg.testreg.bit2  //
#define SEL_PIN             portb_reg.testreg.bit1  //
#define CLK_DIR             trisb_reg.testreg.bit4  //
#define MOSI_DIR            trisb_reg.testreg.bit3  //
#define SEL_DIR             trisb_reg.testreg.bit1  //
#define IRQ_DIR             trisb_reg.testreg.bit0  //
*/

#define CLK_PIN             portb_reg.testreg.bit4  //
#define MOSI_PIN            portb_reg.testreg.bit3 //
#define MISO_PIN            portc_reg.testreg.bit4  //
#define SEL_PIN             portb_reg.testreg.bit5  //
#define CLK_DIR             trisb_reg.testreg.bit4  //
#define MOSI_DIR            trisb_reg.testreg.bit3  //
#define SEL_DIR             trisb_reg.testreg.bit5  //
#define IRQ_DIR             trisb_reg.testreg.bit0  //
#define TRIGGER_DIR         trisb_reg.testreg.bit1
#define TRIGGER2_DIR        trisb_reg.testreg.bit2

/*Test outputs*/                                   //Functions:
#define LED4                portc_reg.testreg.bit5 //it is 1 during the software is in the State_Machine() function
#define STATE3              portc_reg.testreg.bit3 //EzInternalState3
#define LED3                portc_reg.testreg.bit2 //EzInternalState2
#define LED2                portc_reg.testreg.bit1 //EzInternalState1
#define LED1                portc_reg.testreg.bit0 //EzInternalState0
#define TRIGGER             portb_reg.testreg.bit1 //Trigger output
#define TRIGGER2            portb_reg.testreg.bit2 //it show the Timer1 interval



#define PB1             porta_reg.testreg.bit2  //
#define PB2             porta_reg.testreg.bit3  //
#define PB3             porta_reg.testreg.bit4  //
#define PB4             porta_reg.testreg.bit5  //
#define PB1_DIR         trisa_reg.testreg.bit2  //
#define PB2_DIR         trisa_reg.testreg.bit3  //
#define PB3_DIR         trisa_reg.testreg.bit4  //
#define PB4_DIR         trisa_reg.testreg.bit5  //
#define STATE3_DIR         trisa_reg.testreg.bit5  //
#else                                               //16F876
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//              This is the debug I/O setting, can be
//                       omitted if confusing!!!
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


#define CLK_PIN             portb_reg.testreg.bit4  //
#define MOSI_PIN            portb_reg.testreg.bit3 //
#define MISO_PIN            portc_reg.testreg.bit4  //
#define SEL_PIN             portb_reg.testreg.bit5  //
#define CLK_DIR             trisb_reg.testreg.bit4  //
#define MOSI_DIR            trisb_reg.testreg.bit3  //
#define SEL_DIR             trisb_reg.testreg.bit5  //
#define IRQ_DIR             trisb_reg.testreg.bit0  //
#define TRIGGER_DIR         trisb_reg.testreg.bit1
#define TRIGGER2_DIR        trisb_reg.testreg.bit2

/*Test outputs*/                                   //Functions:
#define LED4                portc_reg.testreg.bit5 //it is 1 during the software is in the State_Machine() function
#define STATE3              portc_reg.testreg.bit3 //EzInternalState3
#define LED3                portc_reg.testreg.bit2 //EzInternalState2
#define LED2                portc_reg.testreg.bit1 //EzInternalState1
#define LED1                portc_reg.testreg.bit0 //EzInternalState0
#define TRIGGER             portb_reg.testreg.bit1 //Trigger output
#define TRIGGER2            portb_reg.testreg.bit2 //it show the Timer1 interval



#define PB1             porta_reg.testreg.bit2  //
#define PB2             porta_reg.testreg.bit3  //
#define PB3             porta_reg.testreg.bit4  //
#define PB4             porta_reg.testreg.bit5  //
#define PB1_DIR         trisa_reg.testreg.bit2  //
#define PB2_DIR         trisa_reg.testreg.bit3  //
#define PB3_DIR         trisa_reg.testreg.bit4  //
#define PB4_DIR         trisa_reg.testreg.bit5  //
#define STATE3_DIR         trisa_reg.testreg.bit5  //

#endif                           //#ifdef END_HARDWARE


                /* ======================================= *
                 *     T Y P E   D E C L A R A T I O N     *
                 * ======================================= */

typedef enum  { FALSE = 0, TRUE } bool;



typedef union
{
   reg_union bytes[2];
   int16 adat;
}reg16_union;
//////////////////////////////////
// CONTROL REGISTER DEFINITIONS //
//////////////////////////////////

typedef struct { // MCR (Master Control Register) bits
   unsigned int NRF   : 3;
   unsigned int ADEN  : 1;
   unsigned int DNPL  : 1;
   unsigned int CIDEN : 1;
   unsigned int NWAD  : 1;
   unsigned int RAR   : 1;
} T_MCR;

typedef struct { // TCR (Transmission Control Register) bits
   unsigned int TF    : 3;
   unsigned int OP    : 3;
   unsigned int LBTEN : 1;
   unsigned int AXOT  : 1;
} T_TCR;

typedef struct { // RCR (Receiving Control Register) bits
   unsigned int RF    : 3;
   unsigned int SCHEN : 1;
   unsigned int RSSL  : 3;
   unsigned int AXOR  : 1;
} T_RCR;

typedef struct { // PFCR (Packet Filter Control Register) bits
   unsigned int ApnM  : 1;
   unsigned int PREN  : 1;
   unsigned int PLFEN : 1;
   unsigned int BCEN  : 1;
   unsigned int MCFEN : 1;
   unsigned int DFEN  : 1;
   unsigned int SFEN  : 1;
   unsigned int CFEN  : 1;
} T_PFCR;


//////////////////////////////////////
// DATA/STATUS REGISTER DEFINITIONS //
//////////////////////////////////////

typedef struct { // MSR/state bits
   unsigned int resvd : 2;
   unsigned int S0    : 1;
   unsigned int S1    : 1;
   unsigned int TX    : 1;
   unsigned int RX    : 1;
   unsigned int IDLE  : 1;
   unsigned int WKUP  : 1;
} T_MSR;

typedef struct {
   unsigned int PRF   : 3;
   unsigned int DRSSI : 1;
   unsigned int resvd : 1;
   unsigned int BCA   : 1;
   unsigned int MCA   : 1;
   unsigned int SELFA : 1;
} T_RSR;



typedef struct { // registers bit-by-bit

/// CONTROL REGISTERS

   T_MCR    MCRB;
   T_TCR    TCRB;
   T_RCR    RCRB;
   T_PFCR   PFCRB;
   byte     FR[NMBR_OF_CHANNELS];
   byte     FMASKB;
   byte     CIDB;
   byte     SFLTB;
   byte     SMSKB;
   byte     SFIDB;
   byte     RPLB;

/// DATA & STATUS REGISTERS

   T_MSR    MSRB;
   T_RSR    RSRB;
   byte     RX_CIDB;
   byte     SIDB;
   byte     DIDB;
   byte     PLENB;
   byte     DBuff[PLEN_MAX];

} T_EZRegfield;



typedef struct { // registers by byte

/// CONTROL REGISTERS

   byte     MCRB;
   byte     TCRB;
   byte     RCRB;
   byte     PFCRB;
   byte     FR[NMBR_OF_CHANNELS];
   byte     FMASKB;
   byte     CIDB;
   byte     SFLTB;
   byte     SMSKB;
   byte     SFIDB;
   byte     RPLB;

/// DATA & STATUS REGISTERS

   byte     MSRB;
   byte     RSRB;
   byte     RX_CIDB;
   byte     SIDB;
   byte     DIDB;
   byte     PLENB;
   byte     DBuff[PLEN_MAX];

} T_EZRegbytes;


_NEAR__ union {
   T_EZRegfield   bits;
   T_EZRegbytes   bytes;
   byte           arr[REGBANK_SIZE + DATABANK_SIZE];
// Changed by Laszlo Kadar on 29.11.05
#ifdef HITECH_COMPILER
 } BANK_1 EZ_reg;
#endif
#ifdef CCS_C_COMPILER
 } EZ_reg;
#endif

#ifdef FIX_MEM_ADDRESS
#pragma locate EZ_reg = 0x2B
#endif

// shortcut for state register:
#define EZ_state EZ_reg.bytes.MSRB
#define EZ_dbuff EZ_reg.bytes.DBuff

typedef enum
{
    Config_command,
    Power_command,
    Freq_command,
    Data_Rate_command,
    RX_Ctrl_command,
    Data_Filter_command,
    Fifo_command,
    AFC_command,
    TX_Ctrl_command,
    Wake_command,
    Low_Duty_command,
    LBD_command
}Command_words;

typedef struct { // EZradio registers

   int16 ConfigW;
   int16 PowerW;
   int16 FreqW;
   int16 DataW;
   int16 RX_CtrlW;
   int16 Data_FltW;
   int16 FifoW;
   int16 AFCW;
   int16 TX_CtrlW;
   int16 WakeW;
   int16 Low_DutyW;
   int16 LBDW;
} stru_EZRadioregs;

#define NR_OF_CMDS   12

_NEAR__ union {
   stru_EZRadioregs    words;
   int16               arr[NR_OF_CMDS];
// Changed by Laszlo Kadar on 29.11.05
#ifdef HITECH_COMPILER
 } BANK_1 EZ_commands;
#endif
#ifdef CCS_C_COMPILER
 } EZ_commands;
#endif

/*#ifdef FIX_MEM_ADDRESS
#locate EZ_commands = 0x6C
#endif*/

                /* ======================================= *
                 *            V A R I A B L E S            *
                 * ======================================= */


// Changed by Laszlo Kadar on 29.11.05
#ifdef HITECH_COMPILER
 volatile static _NEAR__ int8 BANK_2 Frequency,EZ_crccnt;              //the current frequency channel
 volatile static _NEAR__ reg16_union BANK_2 EZ_crc;                    //the current CRC value
 volatile static _NEAR__ state BANK_2 EZInternalState;                 //internal states
 volatile static _NEAR__ int8 BANK_2 DataByteCounter;                  //temp variable for the State_Machine
 volatile static _NEAR__ int8 BANK_2 Data, Data1;                      //temp registers for State_Machine
 volatile static _NEAR__ BOOL BANK_2 SetSpiEn;                         //In Rx states it shouldn't set the SPI select pin to 1 in the Interrupt routine, because the
                                                       //state machine will read the data byte from the FIFO after the status read command
                                                       //if SetSpiEn = 1 - the interrupt routine will set the SPI select pin
 volatile static _NEAR__ int8 BANK_2 ARSSI_value;                      //this variable contains the last ARSSI value                                 
#endif
#ifdef CCS_C_COMPILER
 volatile static int8 Frequency,EZ_crccnt;              //the current frequency channel
 volatile static reg16_union EZ_crc;                    //the current CRC value
 volatile static state EZInternalState;                 //internal states
 volatile static int8 DataByteCounter;                  //temp variable for the State_Machine
 volatile static int8 Data, Data1;                      //temp registers for State_Machine
 volatile static BOOL SetSpiEn;                         //In Rx states it shouldn't set the SPI select pin to 1 in the Interrupt routine, because the
                                                       //state machine will read the data byte from the FIFO after the status read command
                                                       //if SetSpiEn = 1 - the interrupt routine will set the SPI select pin
 volatile static int8 ARSSI_value;                      //this variable contains the last ARSSI value                                 
#endif

/*
int16 Config_command;
int16 Power_command;
int16 Freq_command;
int16 Data_Rate_command;
int16 RX_Ctrl_command;
int16 Data_Filter_command;
int16 Fifo_command;
int16 AFC_command;
int16 TX_Ctrl_command;
int16 Wake_command;
int16 Low_Duty_command;
int16 LBD_command;
*/
#ifdef FIX_MEM_ADDRESS
#pragma locate EZ_crc = 0x5D
#pragma byte Frequency = 0x5F
#pragma byte EZ_crccnt = 0x60
#pragma byte EZInternalState = 0x61
#pragma byte DataByteCounter = 0x66
#pragma byte Data = 0x6A
#pragma byte Data1 = 0x6B
#pragma bit  SetSpiEn = 0x64.4
/*
#locate Config_command = 0x6C
#locate Power_command = 0x6E
#locate Freq_command = 0x70
#locate Fifo_command = 0x72
//#locate Data_Rate_command = 0x74
#locate RX_Ctrl_command = 0x74
/*#locate Data_Filter_command = 0x
#locate AFC_command = 0x
#locate TX_Ctrl_command = 0x
#locate Wake_command = 0x
#locate Low_Duty_command = 0x
#locate LBD_command = 0x  */
#endif



                /* ======================================= *
                 *        M I S C E L L A N E O U S        *
                 * ======================================= */
/* void */


                /* ======================================= *
                 *  F U N C T I O N   P R O T O T Y P E S  *
                 * ======================================= */


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  +
  + FUNCTION NAME:  Ch_Check_Start
  +
  + DESCRIPTION:    Set the frequency of the channel (input parameter), set the Timer
  +                 and start checking of the channel.
  +
  + RETURN:         none.
  +
  + NOTES:
  +
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
#pragma separate
void Ch_Check_Start (bool ChangeFreq);


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  +
  + FUNCTION NAME:  DQD_Check
  +
  + DESCRIPTION:    Read the DQD and return the value.
  +
  + RETURN:         TRUE:  DQD = 1 (the channel is occupied)
  +                 FALSE: DQD = 0 (the channel is free)
  +
  + NOTES:
  +
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
#pragma separate
bool DQD_Check (void);


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  +
  + FUNCTION NAME:  State_Machine
  +
  + DESCRIPTION:    EZmac's state machine implementation.
  +
  + RETURN:         none.
  +
  + NOTES:          The function is called from the Timer or External ISR.
  +                 It_Source parameter shows from witch ISR was called the function.
  +
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
#pragma separate
void State_Machine (char It_Source);


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  +
  + FUNCTION NAME:  Crc_On_Fly
  +
  + DESCRIPTION:    Calculate the CRC value from byte to byte during the receiving.
  +
  + RETURN:         Crc: the current value of the CRC
  +
  + NOTES:          Data is the current input byte.
  +                 Crc is an input and output parameter too. The state machine should store
  +                 the previously Crc value and this is the input parameter for the next crc calculation.
  +                 If the state machine want to reset the crc calculations, then it should call the
  +                 function with Crc = 0 value.
  +
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
#pragma separate
// Changed by Laszlo Kadar on 26.11.05
void Crc_On_Fly(int8 Data);

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  +
  + FUNCTION NAME:  Crc_Init
  +
  + DESCRIPTION:    Initialise the CRC routine
  +
  + RETURN:         none.
  +
  + NOTES:          This function should call before the first calling of the Crc_On_Fly routine.
  +
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
void Crc_Init(void);

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  +
  + FUNCTION NAME:  void _Set_Timer1(char Limit)
  +
  + DESCRIPTION:    Set and start the Timer1. Input parameter is the TIMER_LIMIT defines
  +
  + RETURN:         none.
  +
  + NOTES:
  +
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
#pragma separate
void _Set_Timer1(int16 Limit);
#ifdef CCS_C_COMPILER
 #pragma inline
 void _Turn_Off_Timer1(void);
#endif
#ifdef HITECH_COMPILER
 void _Turn_Off_Timer1(void);
// #pragma inline(_Turn_Off_Timer1);
#endif

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  +
  + FUNCTION NAME:  void EZ_Reg_Default(void)
  +
  + DESCRIPTION:    Set the default values to the EZ_reg
  +
  + RETURN:         none.
  +
  + NOTES:
  +
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
#pragma separate
void EZ_Reg_Default(void);

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  +
  + FUNCTION NAME:  void EZ_Radio_Config(void)
  +
  + DESCRIPTION:    Configures the EZradio with default values
  +
  + RETURN:         none.
  +
  + NOTES:
  +
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
#pragma separate
void EZ_Radio_Config(void);

#pragma separate
char EZRadio_CMD_Write (int8 CMD_index);

#endif
#pragma list
